*               TAREA 2, IN34A. OTOO 2006

option LIMCOL=0,LIMROW=0;
$offlisting

*               DEFINICION DE LOS CONJUNTOS

Sets

        t               periodos        /t1*t5/

        i               localidades     /i1*i7/

        j               clientes        /j1*j3/

        ;

*               DECLARACION DE LOS ALIAS

                alias(t,tt) ;

*               DECLARACION DE LOS PARAMETROS

Parameters
        Cap(i)           capacidad de planta en localidad i
/
i1      1021
i2      1231
i3      1365
i4       980
i5      1187
i6      1114
i7      1012
/

        C(i)           costo unitario de produccin en localidad i
/
i1        0.7
i2        0.62
i3        0.73
i4        0.72
i5        0.65
i6        0.89
i7        0.82
/

Table    a(i,t)           costo de construccin de planta en localidad i tiempo t
          t1     t2      t3          t4          t5
i1        3363   3026    3631        2949        4033
i2        1067   960     1152        935         1279
i3        1693   1523    1927        1484        2030
i4        5947   5352    6422        5245        7134
i5        991    891     1069        869         1187
i6        3200   2880    3465        2809        3839
i7        5363   4827    5792        4703        6434

Table    d(i,j)          costo de transporte de localidad i a cliente j
         j1       j2       j3
i1       0.35     0.68     0.62
i2       0.22     0.87     0.58
i3       0.8      0.49     0.5
i4       0.79     0.84     0.33
i5       0.26     0.72     0.42
i6       0.44     0.67     0.58
i7       0.12     0.6      0.68


Table    U(j,t)           demanda del cliente j en tiempo t
         t1      t2      t3      t4      t5
j1       205     590     750     985     1260
j2       730     730     660     1046    1197
j3       840     835     910     1520    1610


*               DEFINICION DE VARIABLES

Variables

        Cto_Cons         costo construccion
        Cto_Tran         costo transporte
        Cto_Prod         costo produccion

        FObj             funcion objetivo

        x(i,t)           si la planta en localidad i es construida en tiempo t
        z(i,j,t)         numero de productos transportados de i a j en tiempo t

        ;

*               NATURALEZA DE LAS VARIABLES

        Positive variable Cto_Cons ;
        Positive variable Cto_Prod ;
        Positive variable Cto_Tran ;
        Free Variable FObj ;

        Binary variables x ;
        Positive variable z ;


*               DECLARACION DE LAS RESTRICCIONES

Equations

        C_CONS                           costos de construccion
        C_PROD                           costos de produccion
        C_TRAN                           costos de transporte
        func_obj                         funcion objetivo

        max_const(i)             construyo a lo mas una vez por localidad
        lim_prod(i,t)            limite de produccin por capacidad
        sat_dda(j,t)             satisfaccion de la demanda en los clientes para cada periodo

        ;
*               DEFINICION DE LAS RESTRICCIONES


        max_const(i) ..
        sum(t,x(i,t)) =l= 1 ;

        sat_dda(j,t) ..
        sum(i,z(i,j,t)) =g= U(j,t) ;

        lim_prod(i,t) ..
        sum(j,z(i,j,t)) =l= Cap(i)* sum(tt$( ord(tt) le ord(t)), x(i,tt)) ;


*               DEFINICION DE LA FUNCION OBJETIVO

C_CONS ..
        Cto_Cons =e= sum(t, (sum(i, x(i,t)*a(i,t)))) ;

C_PROD ..
        Cto_Prod =e= sum(t, (sum(i, C(i)*sum(j,z(i,j,t))))) ;

C_TRAN ..
        Cto_Tran =e= sum(t, (sum(j, sum(i, (d(i,j)*z(i,j,t)))))) ;

func_obj ..
        FObj =e= Cto_Cons + Cto_Prod + Cto_Tran ;


*               CREACION Y EJECUCION DEL MODELO

MODEL tarea2 / all /;

SOLVE tarea2 USING MIP MINIMIZING FObj ;

display x.l, z.l;


*               GENERACION DE REPORTES

file output /tarea2b.txt/;

put output ;
output.lw=0 ;
output.nw=0 ;
output.sw=0 ;
output.tw=0 ;
output.nd=0 ;
output.pw=1000 ;

put @10, "RESULTADOS"/;

put @5, "Funcion Objetivo: ", Fobj.l/;

loop(t,
        put @5,"Construcciones en periodo ", t.tl, ":"/;
        loop(i,
                if(x.l(i,t)=1,put @10, "Planta ", i.tl/);
        );
put @5, ""/;
);
put @5, ""/;

loop(t,
        put @5,"Transportes en el periodo ", t.tl, ":"/;
        loop(i, loop(j,
                if(z.l(i,j,t) > 0,put @10, z.l(i,j,t), " desde la planta ", i.tl, " al mercado ", j.tl/);
        ));
        put @5, "Produccion total en el periodo ", t.tl, ": ", sum(i, (sum(j, z.l(i,j,t))))/;
put @5, ""/;
);
put @5, ""/;